
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Project IDs and corresponding code coverage percentages
project_ids = np.arange(1, 11)
code_coverage = np.random.uniform(50, 100, 10)
upper_error = np.random.uniform(2, 5, 10)
down_error = np.random.uniform(1, 3, 10)
left_error = [0.5] * 10
right_error = [0.5] * 10

# Chart labels and title
xlabel = "Project ID"
ylabel = "Code Coverage (%)"
title = "Code Coverage Across Software Projects"
xhline = 70
label = "Coverage Error"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 7))
ax.errorbar(
    project_ids,
    code_coverage,
    xerr=[left_error, right_error],
    yerr=[down_error, upper_error],
    fmt="o",
    color="#006699",
    ecolor="#FF9933",
    capsize=5,
    label=label,
)
for i, (project_id, coverage, uperror, downerror) in enumerate(zip(project_ids, code_coverage, upper_error, down_error)):
    ax.text(
        project_id + 0.25, coverage + 0.5 * uperror, r"$+%.1f$" % (uperror), va="center", ha="center", fontsize=8, color="blue"
    )
    ax.text(
        project_id + 0.25, coverage - 0.5 * downerror, r"$-%.1f$" % (downerror), va="center", ha="center", fontsize=8, color="red"
    )
ax.set_title(title, fontsize=16, fontweight='bold')
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.legend(loc='upper right')
ax.axhline(xhline, color="green", linestyle="--", linewidth=2)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorpoint_43.pdf", bbox_inches="tight")

