

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(13)
years = np.linspace(2010, 2019, 10)
temperatures = np.random.uniform(14, 25, 10)
left_error = np.random.uniform(0.5, 2, 10)
right_error = np.random.uniform(0.5, 2, 10)

title = "Average Yearly Temperature with Asymmetric Error"
xlabel = 'Year'
ylabel = 'Temperature (°C)'
legend_label = 'Temperature Data'
annotation_offset = 0.5

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 7))
ax.errorbar(
    years,
    temperatures,
    xerr=[left_error, right_error],
    fmt="^",
    color="#3498db",
    ecolor="#2ecc71",
    elinewidth=1,
    capsize=5,
    linestyle='dashed',
    label=legend_label,
)
for i, (xi, yi, lefterror, righterror) in enumerate(zip(years, temperatures, left_error, right_error)):
    ax.text(
        xi - 0.8 * lefterror,
        yi + annotation_offset,
        r"${-%.1f}$" % (lefterror),
        va="center",
        ha="center",
        fontsize=9,
    )
    ax.text(
        xi + 0.8 * righterror,
        yi + annotation_offset,
        r"${+%.1f}$" % (righterror),
        va="center",
        ha="center",
        fontsize=9,
    )
ax.set_title(title, fontsize=16)
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.legend(loc="upper left", fontsize=10)
ax.yaxis.grid(True)
ax.set_ylim(13, 27)
# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorpoint_47.pdf", bbox_inches="tight")

