
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
cities = [
    "New York",
    "Los Angeles",
    "Chicago",
    "Houston",
    "Phoenix",
    "Philadelphia",
]

average_temperatures = np.random.uniform(5.0, 25.0, len(cities))  # Average temperature in Celsius
std_devs = np.random.uniform(2.0, 5.0, len(cities))
dataset_mean = np.mean(average_temperatures)

# Labels and Plot Types
label_Mean = "Mean Temperature"
label_Dataset_mean = "Average Temperature"

# Axes Limits and Labels
ylabel_value = "Temperature (°C)"
title = "Average Monthly Temperatures by City"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(10, 6))
ylim_values = [-10, 40]
# Error bar plot with optimized style
ax.errorbar(
    cities,
    average_temperatures,
    yerr=std_devs,
    fmt="o",
    color="forestgreen",
    ecolor="darkorange",
    elinewidth=2,
    capsize=5,
    markerfacecolor="limegreen",
    label=label_Mean,
)

# Dataset mean line
ax.axhline(
    y=dataset_mean,
    color="maroon",
    linestyle="--",
    linewidth=2,
    label=label_Dataset_mean,
)

# Customizing the plot
ax.set_ylabel(ylabel_value, fontsize=12)
ax.set_xticklabels(cities, rotation=45, ha="right", fontsize=10)
ax.legend(fontsize=10)
ax.set_ylim(ylim_values)

# Title for the plot
ax.set_title(title, fontsize=14, fontweight="bold")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent clipping of tick-labels
plt.tight_layout()
plt.savefig("errorpoint_52.pdf", bbox_inches="tight")
