# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
age_groups = ["Infants", "Toddlers", "Children", "Teens", "Adults", "Seniors"]
average_sleep_needed = [14, 12, 10, 9, 8, 7]  # Average sleep needed (hours)
sleep_variance = [1, 0.5, 1, 1, 0.5, 0.5]  # Sleep variance (hours)
overall_avg_sleep = [8.5]  # Overall average sleep recommendation (hours)

# Text labels
xlabel = "Average Sleep Needed (hours)"
label = "Overall Avg Sleep"
plot_title = "Average Sleep Needed by Age Group"
errorbar_label = "Age Group Sleep Mean"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(10, 7))  # Adjusting figure size for better readability
plt.errorbar(
    average_sleep_needed,
    age_groups,
    xerr=sleep_variance,
    fmt="o",
    color="#1f77b4",
    ecolor="#ff7f0e",
    capsize=5,
    elinewidth=2,
    markeredgewidth=2,
    label=errorbar_label,
)
plt.axvline(
    overall_avg_sleep[0], color="#2ca02c", linestyle="--", linewidth=3, label=label
)

# Customizing the plot
plt.xlabel(xlabel)
plt.title(plot_title)
plt.legend(loc="upper right")
plt.grid(True, linestyle="--", linewidth=0.5, alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting the layout and saving the figure
plt.tight_layout()
plt.savefig("errorpoint_56.pdf", bbox_inches="tight")
