
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
import numpy as np

np.random.seed(42)
products = [
    "Product A",
    "Product B",
    "Product C",
    "Product D",
    "Product E",
    "Product F",
    "Product G",
    "Product H",
    "Product I",
    "Product J",
]
sales_changes = [
    5,  # Percent
    8,
    6,
    10,
    4,
    7,
    9,
    5,
    6,
    4,
]
errors = [
    [2, -1],  # Error margins in Percent
    [3, -2],
    [1, -1],
    [2, -2],
    [1, -1],
    [2, -1],
    [3, -2],
    [1, -1],
    [2, -1],
    [1, -1],
]
reasons = [
    "Advertising Campaign",
    "Seasonal Discount",
    "New Product Launch",
    "Supply Chain Optimization",
    "Customer Feedback",
    "Market Expansion",
    "Product Upgrade",
    "Customer Loyalty Program",
    "Partnership Deals",
    "Online Promotions",
]
xticks = np.arange(0.0, 14, 2)  # Adjusted for sales percentage scale
xlim = [0.0, 14]
xvline = 7.0  # Average sales change in Percent
xvspan = [6, 8]  # Range near average sales change
xlabel = "Monthly Sales Change (%)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(10, 8))

# Error bars with different positive and negative values
for i, (product, value, error) in enumerate(zip(products, sales_changes, errors)):
    ax.errorbar(
        value,
        i,
        xerr=[[abs(error[1])], [error[0]]],
        fmt="o",
        color="green",
        ecolor="blue",
        capsize=3,
    )
    ax.text(
        value,
        i - 0.15,
        r"$%.1f^{+%.2f} _{-%.2f}$" % (value, error[0], abs(error[1])),
        va="center",
        ha="center",
        fontsize=9,
    )

# Highlighted region with adjusted color and alpha
ax.axvspan(xvspan[0], xvspan[1], color="lightblue", alpha=0.3)

# Text for reasons with adjusted font size
for i, reason in enumerate(reasons):
    ax.text(14, i, reason, va="center", ha="left", fontsize=11)

# Set labels and title
ax.set_yticks(range(len(products)))
ax.set_yticklabels(products)
ax.set_xlabel(xlabel, fontsize=12)
ax.set_xlim(xlim)
ax.invert_yaxis()  # Invert y-axis to match the original image
ax.axvline(x=xvline, linestyle="--", color="orange")
# Adjust x-axis ticks and labels
ax.set_xticks(xticks)
ax.set_xticklabels([f"{x:.1f}" for x in xticks])

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save/show the plot
plt.tight_layout()
plt.savefig("errorpoint_58.pdf", bbox_inches="tight")
