

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for Sports Domain
categories = [
    "Basketball",
    "Soccer",
    "Tennis",
    "Baseball",
    "Cricket",
    "Hockey",
]
unique_speaker_mean = [
    80,
    95,
    70,
    85,
    65,
    75,
]
unique_shouter_mean = [
    35,
    45,
    30,
    40,
    28,
    33,
]
unique_speaker_error = [
    7,
    6.5,
    6,
    5.5,
    5,
    5.2,
]
unique_shouter_error = [
    4,
    3.5,
    3.2,
    3.8,
    3,
    3.1,
]
xlabel = categories
ylabel = "Number of Unique Speakers"
axlabel = "Average Unique Shouter Count"
title = "Average Number of Unique Speakers and Shouters in Different Sports"
legendlabels = ["Unique speaker count mean", "Unique shouter count mean"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(12, 8))

# Custom Colors and Markers
ax.errorbar(
    categories,
    unique_speaker_mean,
    yerr=unique_speaker_error,
    fmt="o",
    color="teal",
    label=legendlabels[0],
    capsize=10,
    markersize=8,
    elinewidth=2,
    markeredgewidth=2,
)
ax.errorbar(
    categories,
    unique_shouter_mean,
    yerr=unique_shouter_error,
    fmt="s",
    color="darkorange",
    label=legendlabels[1],
    capsize=10,
    markersize=8,
    elinewidth=2,
    markeredgewidth=2,
)

# Customization
ax.set_ylabel(ylabel)
ax.set_xticklabels(categories, rotation=45, ha="right")

# Adding a horizontal line for mean shouter count
ax.axhline(
    y=np.mean(unique_shouter_mean),
    color="grey",
    linestyle="--",
    linewidth=2,
    label=axlabel,
)

ax.legend()
ax.set_title(title)
plt.tight_layout()

# ===================
# Part 4: Saving Output
# ===================
plt.savefig("errorpoint_62.pdf", bbox_inches="tight")

