

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for plotting: Renewable Energy Sources
categories = [
    "Solar",
    "Wind",
    "Hydropower",
    "Biomass",
    "Geothermal",
]

# Generated mean values for the prevalence in global energy consumption
means = [0.20, 0.30, 0.25, 0.15, 0.10]
errors = [0.03, 0.04, 0.05, 0.02, 0.03]
downerrors = [0.02, 0.03, 0.04, 0.01, 0.02]

# Texts and labels
legendtitles = ["Mean", "Global Average"]
texttitle = "Overall Global Average"
title = "Prevalence of Renewable Energy Sources in Global Energy Consumption"
ylabel = "Prevalence Fraction"
xlabel = "Renewable Energy Source"
dataset_mean = np.mean(means)  # Calculated dataset mean

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
fig, ax = plt.subplots(figsize=(10, 6))

# Custom color scheme
marker_color = "mediumslateblue"
error_color = "slategray"
dataset_line_color = "gray"

ax.errorbar(
    categories,
    means,
    yerr=[errors, downerrors],
    fmt="o",
    color=marker_color,
    ecolor=error_color,
    capsize=5,
    markerfacecolor="lavender",
    markeredgewidth=2,
    markeredgecolor=marker_color,
)

# Adding a legend with both "Mean" and "Global Average"
mean_line = ax.errorbar(
    [], [], yerr=[], fmt="o", color=marker_color, ecolor=error_color, capsize=5
)
dataset_mean_line = ax.axhline(
    y=dataset_mean, color=dataset_line_color, linestyle="--", linewidth=1
)
ax.legend(
    [dataset_mean_line, mean_line],
    legendtitles,
    loc="upper left",
    fancybox=True,
    framealpha=1,
    shadow=True,
    borderpad=1,
)

# Adding a horizontal line for dataset mean and text annotation with a white background
ax.text(
    0.95,
    dataset_mean,
    texttitle,
    va="center",
    ha="right",
    backgroundcolor="white",
    transform=ax.get_yaxis_transform(),
)

# Setting labels and a title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
plt.xticks(rotation=30)
plt.grid(True, which="both", axis="y", linestyle="--", linewidth=0.5)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorpoint_70.pdf", bbox_inches="tight")

