

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Financial data: average closing stock prices ($) over 10 months
x = np.arange(1, 11, 1)
y = [
    120.5,
    125.3,
    123.1,
    126.7,
    128.4,
    130.2,
    127.9,
    129.5,
    131.0,
    134.1,
]
error = np.array([2.5, 3.0, 2.8, 3.2, 2.6, 2.9, 2.7, 3.1, 2.8, 2.9])  # symmetric error
lower_error = 0.4 * error  # Adjusted asymmetric error
upper_error = error
asymmetric_error = [lower_error, upper_error]

title1 = "Average Closing Stock Prices with Symmetric Error Margins"
title2 = "Average Closing Stock Prices with Asymmetric Error Margins"
xlabel = "Time (Months)"
ylabel = "Stock Price ($)"
legend_label = "Stock Price Data"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, (ax0, ax1) = plt.subplots(figsize=(12, 6), ncols=2, sharex=True)

# Plot with symmetric error
ax0.errorbar(
    x,
    y,
    yerr=error,
    fmt="o",
    color="mediumseagreen",
    ecolor="darkred",
    elinewidth=2,
    capsize=5,
    label=legend_label,
)
ax0.set_title(title1, fontsize=14)
ax0.set_xlabel(xlabel, fontsize=12)
ax0.set_ylabel(ylabel, fontsize=12)
ax0.legend()

# Plot with asymmetric error
ax1.errorbar(
    x,
    y,
    yerr=asymmetric_error,
    fmt="d",
    color="royalblue",
    ecolor="darkorange",
    elinewidth=2,
    capsize=5,
    label=legend_label,
)
ax1.set_title(title2, fontsize=14)
ax1.set_xlabel(xlabel, fontsize=12)
ax1.set_yscale("log")
ax1.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorpoint_73.pdf", bbox_inches="tight")

