

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# example book sales data
x = np.arange(1, 13, 1)
y = [
    100, 120, 150, 200, 170, 140, 160, 210, 220, 180, 190, 230
]  # average monthly book sales (in units)
error = np.array([10, 15, 12, 18, 14, 13, 11, 17, 19, 14, 13, 16])  # symmetric error
lower_error = 0.8 * error  # Adjusted asymmetric error
upper_error = error
asymmetric_error = [lower_error, upper_error]

title1 = "Monthly Book Sales with Symmetric Error Margins"
title2 = "Monthly Book Sales with Asymmetric Error Margins"
xlabel = "Time (Months)"
ylabel = "Book Sales (in units)"
legend_label = "Sales Data"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, (ax0, ax1) = plt.subplots(figsize=(12, 6), ncols=2, sharex=True)

# Plot with symmetric error
ax0.errorbar(
    x,
    y,
    yerr=error,
    fmt="o",
    color="mediumseagreen",
    ecolor="lightgray",
    elinewidth=2,
    capsize=5,
    label=legend_label,
)
ax0.set_title(title1, fontsize=14)
ax0.set_xlabel(xlabel, fontsize=12)
ax0.set_ylabel(ylabel, fontsize=12)
ax0.legend()

# Plot with asymmetric error
ax1.errorbar(
    x,
    y,
    yerr=asymmetric_error,
    fmt="v",
    color="royalblue",
    ecolor="darkorange",
    elinewidth=2,
    capsize=5,
    label=legend_label,
)
ax1.set_title(title2, fontsize=14)
ax1.set_xlabel(xlabel, fontsize=12)
ax1.set_ylabel(ylabel, fontsize=12)
ax1.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorpoint_74.pdf", bbox_inches="tight")

