

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Cities and weeks
cities = ["City X", "City Y", "City Z"]
weeks = ["Week 1", "Week 2", "Week 3", "Week 4", "Week 5", "Week 6"]

# Positions for x-axis
x_positions = np.arange(len(weeks))

# Internet speed data for six weeks (in Mbps)
city_x_speeds = np.random.uniform(50, 100, len(weeks))
city_y_speeds = np.random.uniform(70, 120, len(weeks))
city_z_speeds = np.random.uniform(80, 130, len(weeks))

# Error bars (symmetric)
city_x_error = [np.random.uniform(5, 10, len(weeks)), np.random.uniform(5, 10, len(weeks))]
city_y_error = [np.random.uniform(5, 15, len(weeks)), np.random.uniform(5, 15, len(weeks))]
city_z_error = np.random.uniform(4, 8, len(weeks))

# Horizontal line position for ideal speed range
ideal_speed_range = [90, 110]

# Titles and labels
titles = ["City X Internet Speed Measurements", "City Y Internet Speed Measurements", "City Z Internet Speed Measurements"]
xlabel = "Weeks"
ylabel = "Internet Speed (Mbps)"
legendlabels = ["City X", "City Y", "City Z"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with three subplots and shared x-axis
fig, (ax0, ax1, ax2) = plt.subplots(figsize=(8, 12), nrows=3, sharex=True)
city_x_colors = plt.get_cmap("Blues")(np.linspace(0.2, 0.8, len(weeks)))
city_y_colors = plt.get_cmap("Oranges")(np.linspace(0.2, 0.8, len(weeks)))
city_z_color = "#D62728"  # red

# First subplot with symmetric vertical error bars for City X
for i in range(len(x_positions)):
    ax0.errorbar(
        x_positions[i],
        city_x_speeds[i],
        yerr=[[city_x_error[0][i]], [city_x_error[1][i]]],
        fmt="o",
        color=city_x_colors[i],
        capsize=4,
    )
    ax0.text(
        x_positions[i] - 0.1,
        city_x_speeds[i] + 1,
        f"{city_x_speeds[i]:.1f}",
        fontsize=8,
        ha="right",
    )
ax0.set_title(titles[0])
ax0.axhline(y=np.mean(ideal_speed_range), linestyle="--", color="green")
ax0.yaxis.grid(True)
ax0.xaxis.grid(False)

# Second subplot with symmetric vertical error bars for City Y
for i in range(len(x_positions)):
    ax1.errorbar(
        x_positions[i],
        city_y_speeds[i],
        yerr=[[city_y_error[0][i]], [city_y_error[1][i]]],
        fmt="s",
        color=city_y_colors[i],
        capsize=4,
    )
    ax1.text(
        x_positions[i] - 0.1,
        city_y_speeds[i] + 1,
        f"{city_y_speeds[i]:.1f}",
        fontsize=8,
        ha="right",
    )
ax1.set_title(titles[1])
ax1.axhline(y=np.mean(ideal_speed_range), linestyle="--", color="green")
ax1.yaxis.grid(True)
ax1.xaxis.grid(False)

# Third subplot with symmetric vertical error bars for City Z
ax2.errorbar(
    x_positions,
    city_z_speeds,
    yerr=city_z_error,
    fmt="*",
    color=city_z_color,
    capsize=4,
)
ax2.set_title(titles[2])
ax2.legend(legendlabels, loc="upper left")
ax2.yaxis.grid(True)
ax2.xaxis.grid(False)

# Set overall x and y labels
fig.supxlabel(xlabel)
fig.supylabel(ylabel)

# Set x-ticks and x-tick labels
plt.xticks(ticks=x_positions, labels=weeks)

# Adjust layout and display the plot
plt.tight_layout()
plt.savefig("errorpoint_75.pdf", bbox_inches="tight")

