
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

months = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]
x = np.arange(len(months))  # Months

# Legal data
cases_filed = np.random.uniform(50, 150, len(months))  # Number of cases filed
cases_closed = np.random.uniform(30, 120, len(months))  # Number of cases closed
average_duration = np.random.uniform(15, 90, len(months))  # Average case duration in days

# Error data
error_cases_filed = np.random.uniform(5, 15, len(months))  # Error for cases filed
error_cases_closed = np.random.uniform(3, 12, len(months))  # Error for cases closed
error_duration = np.random.uniform(2, 10, len(months))  # Error for average case duration

# Chart title and labels
chart_title = "Monthly Legal Data with Error Bars"
xlabel = "Month"
ylabel = ["Cases Filed", "Cases Closed", "Avg Case Duration (days)"]
highlight_month = 6  # July

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with three subplots and shared x-axis
fig, (ax0, ax1, ax2) = plt.subplots(figsize=(8, 12), nrows=3, sharex=True)

# Colors
color_cases_filed = "darkred"
color_cases_closed = "navy"
color_duration = "gray"

# First subplot with cases filed
ax0.errorbar(x, cases_filed, yerr=error_cases_filed, fmt="o", color=color_cases_filed, capsize=4)
for i in range(len(x)):
    ax0.text(x[i] - 0.2, cases_filed[i] + 0.5, f"{cases_filed[i]:.2f}", fontsize=8, ha="right")
ax0.set_title(chart_title)
ax0.axhline(y=100, linestyle="--", color="#6b8e23")  # Example threshold line
ax0.set_ylabel(ylabel[0])
ax0.yaxis.grid(True)
ax0.xaxis.grid(False)

# Second subplot with cases closed
ax1.errorbar(x, cases_closed, yerr=error_cases_closed, fmt="s", color=color_cases_closed, markersize=8, capsize=4)
for i in range(len(x)):
    ax1.text(x[i] + 0.1, cases_closed[i] + 0.5, f"{cases_closed[i]:.2f}", fontsize=8, ha="left")
ax1.axvline(x=highlight_month, linestyle="--", color="#d45500")  # Highlight a specific month
ax1.set_ylabel(ylabel[1])
ax1.yaxis.grid(True)
ax1.xaxis.grid(False)

# Third subplot with average case duration
ax2.errorbar(x, average_duration, yerr=error_duration, fmt="*", color=color_duration, capsize=2)
for i in range(len(x)):
    ax2.text(x[i], average_duration[i] + 1.5, f"{average_duration[i]:.2f}", fontsize=8, ha="center")
ax2.set_ylabel(ylabel[2])
ax2.yaxis.grid(True)
ax2.xaxis.grid(False)

# Set shared x-axis labels
plt.xticks(x, months)
ax2.set_xlabel(xlabel)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and display the plot
plt.tight_layout()
plt.savefig("errorpoint_80.pdf", bbox_inches="tight")
