
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import networkx as nx
import numpy as np

# Create a directed graph with movies and sequels
G = nx.DiGraph()
movies = ["Movie 1", "Movie 2", "Movie 3", "Movie 4", "Movie 5"]

# Adding nodes representing movies
for movie in movies:
    G.add_node(movie)

# Adding directed edges representing sequels
edges = [("Movie 1", "Movie 2"), ("Movie 2", "Movie 3"), ("Movie 3", "Movie 4"), ("Movie 4", "Movie 5"), ("Movie 5", "Movie 1")]
self_loops = [("Movie 3", "Movie 3"), ("Movie 5", "Movie 5")]

G.add_edges_from(edges + self_loops)

# Define positions for a circular layout
pos = nx.circular_layout(G)

# Parameters for labels and legend
title = "Movie Sequel Network"
legend_labels = {'Sequels': '-', 'Remakes/Reboots': '--'}

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(12, 10))

# Draw the main graph
node_color = "#2E8B57"
font_weight = 'bold'
font_size = 12
node_size = 700
edge_color = "#4682B4"
loop_edge_color = 'orange'
arrow_style = "-|>"
arrow_size = 20
loop_style = 'dashed'
connection_style = 'arc3,rad=0.3'

nx.draw(G, pos, with_labels=True, node_color=node_color, font_weight=font_weight, font_size=font_size, node_size=node_size, edge_color=edge_color)

# Draw self-loops with different formatting
nx.draw_networkx_edges(G, pos, edgelist=self_loops, style=loop_style, edge_color=loop_edge_color, arrowstyle=arrow_style, arrowsize=arrow_size, connectionstyle=connection_style)

# Adding a legend
handles = [
    plt.Line2D([0], [0], color=edge_color, lw=2, label='Sequels'),
    plt.Line2D([0], [0], color=loop_edge_color, lw=2, linestyle=loop_style, label='Remakes/Reboots')
]
plt.legend(handles=handles, loc='best')

# Setting the title
plt.title(title, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("graph_35.pdf", bbox_inches="tight")
