

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import networkx as nx
import numpy as np

# Create a directed graph representing municipal departments
G = nx.DiGraph()

# Add nodes representing different municipal departments
modules = {
    0: "Healthcare",
    1: "Education",
    2: "Transport",
    3: "Public Safety",
    4: "Utilities",
    5: "Parks and Recreation",
    6: "Housing",
    7: "Waste Management",
    8: "Economic Development",
    9: "Community Services",
    10: "Public Works",
    11: "Environmental Services",
}

G.add_nodes_from(modules.keys())

# Add edges with weights representing collaboration or communication frequency
edges = [
    (0, 1, 5),
    (0, 3, 4),
    (1, 8, 3),
    (2, 4, 5),
    (2, 5, 2),
    (3, 10, 3),
    (4, 7, 2),
    (5, 6, 1),
    (6, 9, 4),
    (7, 11, 3),
    (8, 9, 4),
    (10, 11, 2),
]

G.add_weighted_edges_from(edges)

# Adjust node positions using spring layout for better visualization
pos = nx.spring_layout(G, seed=42)
title = "Municipal Departments and Their Collaboration Relationships"

# Labels for nodes and edges
node_labels = modules
edge_labels = {(start, end): f"{weight}" for start, end, weight in edges}

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(14, 10))

# Draw nodes with varying sizes and more sophisticated color palette
node_size = [1000 + 300 * (i % 3) for i in range(len(modules))]
node_color = [
    "mediumseagreen" if i % 3 == 0 else "cornflowerblue" if i % 3 == 1 else "gray"
    for i in range(len(modules))
]

nx.draw(
    G, pos, node_size=node_size, node_color=node_color, with_labels=False, arrows=True, edge_color='black'
)

# Draw labels for nodes and edges
nx.draw_networkx_labels(G, pos, labels=node_labels, font_size=10, font_color='darkblue')
nx.draw_networkx_edge_labels(G, pos, edge_labels=edge_labels, font_color="darkred", font_size=8)

# Adjust plot parameters for better visualization
plt.title(title, fontsize=16, fontweight='bold')
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show the plot
plt.tight_layout()
plt.savefig("graph_67.pdf", bbox_inches="tight")

