# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import networkx as nx
import numpy as np

# Create a directed graph representing e-commerce company departments
G = nx.DiGraph()

# Add nodes representing different departments
departments = {
    0: "Sales",
    1: "Marketing",
    2: "Customer Service",
    3: "IT Support",
    4: "Logistics",
    5: "HR",
    6: "Finance",
    7: "Product Management",
    8: "Procurement",
    9: "Legal",
    10: "Tech Development",
    11: "Warehouse",
}

G.add_nodes_from(departments.keys())

# Add edges with weights representing communication flow or collaboration (weight = frequency/importance)
edges = [
    (0, 1, 4),
    (1, 2, 3),
    (2, 3, 5),
    (3, 4, 2),
    (4, 5, 3),
    (5, 6, 4),
    (6, 10, 3),
    (1, 7, 4),
    (7, 8, 3),
    (8, 9, 2),
    (9, 10, 1),
    (10, 11, 3),
]

G.add_weighted_edges_from(edges)

# Adjust node positions using spring layout for better visualization
pos = nx.spring_layout(G, seed=42)
title = "E-commerce Company Departments and Their Collaboration Relationships"

# Labels for nodes and edges
node_labels = departments
edge_labels = {(start, end): f"{weight}" for start, end, weight in edges}

# Set node size and color
node_size = [800 + 200 * (i % 3) for i in range(len(departments))]
node_color = [
    "#1f77b4" if i % 3 == 0 else "#2ca02c" if i % 3 == 1 else "#d62728"
    for i in range(len(departments))
]

# Create a legend
legend_labels = {
    "Light Blue": "Node Group 1",
    "Green": "Node Group 2",
    "Red": "Node Group 3",
}

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(14, 10))

# Draw nodes with varying sizes and colors
nx.draw(
    G, pos, node_size=node_size, node_color=node_color, with_labels=False, arrows=True
)

# Draw labels for nodes and edges
nx.draw_networkx_labels(G, pos, labels=node_labels, font_size=9)
nx.draw_networkx_edge_labels(G, pos, edge_labels=edge_labels, font_color="purple")

# Adjust plot parameters for better visualization
plt.title(title, fontsize=15)
plt.axis("off")

handles = [
    plt.Line2D([0], [0], color=color, marker="o", linestyle="", markersize=10)
    for color in ["#1f77b4", "#2ca02c", "#d62728"]
]
plt.legend(handles, legend_labels.values(), loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
# Show the plot
plt.tight_layout()
plt.savefig("graph_68.pdf", bbox_inches="tight")
