
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import networkx as nx

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Creating a graph structure for psychology department layout
G = nx.cubical_graph()
# explicitly set positions (e.g., sections in a psychology department)
pos = {
    0: (0, 0), 1: (2, 0), 2: (0, 2), 3: (2, 2),
    4: (1, 1), 5: (3, 1), 6: (1, 3), 7: (3, 3)
}
labels = {
    0: "Main Office",
    1: "Clinical Psychology",
    2: "Cognitive Psychology",
    3: "Developmental Psychology",
    4: "Neuroscience Lab",
    5: "Social Psychology",
    6: "Behavioral Lab",
    7: "Counseling Center",
}

# Set the plot title and subtitle
title = "Psychology Department Layout and Connectivity"
suptitle = "Network of Sections within the Psychology Faculty"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(14, 12))

# Nodes configuration
nx.draw_networkx_nodes(
    G,
    pos,
    node_size=400,
    nodelist=[0],
    node_color="skyblue",
    edgecolors="black",
    linewidths=3,
)
nx.draw_networkx_nodes(
    G,
    pos,
    node_size=350,
    nodelist=[1, 2, 3, 4, 5, 6, 7],
    node_color="lightgreen",
    edgecolors="black",
    linewidths=2,
)

# Edges configuration
nx.draw_networkx_edges(G, pos, alpha=0.7, width=3, edge_color="mediumaquamarine")

# Adding text annotations - Labels for sections
nx.draw_networkx_labels(
    G, pos, labels=labels, font_size=14, font_color="black", font_family="sans-serif"
)

# Title and axis configurations
plt.title(title, fontsize=26, fontweight="bold")
plt.suptitle(suptitle, fontsize=18, style="italic")
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("graph_75.pdf", bbox_inches="tight")
