
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import networkx as nx

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Creating a directed graph to represent a financial network
G = nx.DiGraph()

# Adding nodes with categories: 0 - Banks, 1 - Investment Firms, 2 - Hedge Funds, 3 - Individuals
nodes = {
    0: "Bank (USA)",
    1: "Bank (UK)",
    2: "Investment Firm (Canada)",
    3: "Investment Firm (Germany)",
    4: "Hedge Fund (Switzerland)",
    5: "Hedge Fund (Japan)",
    6: "Individual (France)",
    7: "Individual (Australia)"
}

# Adding edges to represent the flow of money
edges = [
    (0, 2), (0, 3),
    (1, 2), (1, 3),
    (2, 4), (2, 5),
    (3, 4), (3, 5),
    (4, 6), (5, 7)
]

# Adding nodes and edges to the graph
G.add_nodes_from(nodes.keys())
G.add_edges_from(edges)

# Positioning the nodes manually for clarity
pos = {
    0: (0, 2), 1: (6, 2),
    2: (2, 1), 3: (4, 1),
    4: (2, 0), 5: (4, 0),
    6: (1, -1), 7: (5, -1)
}

# Labels for nodes
labels = nodes

# Set the plot title and subtitle
title = "Financial Network"
suptitle = "Flow of Money Among Financial Institutions and Individuals"

nx.set_node_attributes(G, labels, 'label')

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(14, 10))

# Nodes configuration
nx.draw_networkx_nodes(
    G,
    pos,
    nodelist=[0, 1],
    node_color="lightblue",
    node_size=500,
    edgecolors="black",
    linewidths=2,
    label="Banks",
)
nx.draw_networkx_nodes(
    G,
    pos,
    nodelist=[2, 3],
    node_color="lightgreen",
    node_size=500,
    edgecolors="black",
    linewidths=2,
    label="Investment Firms",
)
nx.draw_networkx_nodes(
    G,
    pos,
    nodelist=[4, 5],
    node_color="orange",
    node_size=500,
    edgecolors="black",
    linewidths=2,
    label="Hedge Funds",
)
nx.draw_networkx_nodes(
    G,
    pos,
    nodelist=[6, 7],
    node_color="salmon",
    node_size=500,
    edgecolors="black",
    linewidths=2,
    label="Individuals",
)

# Edges configuration
nx.draw_networkx_edges(
    G,
    pos,
    edgelist=edges,
    arrowstyle='-|>',
    arrowsize=20,
    edge_color="gray",
    width=2,
    connectionstyle="arc3,rad=0.1"
)

# Adding text annotations
nx.draw_networkx_labels(
    G, pos, labels=labels, font_size=12, font_color="black", font_family="sans-serif"
)

# Title and axis configurations
plt.title(title, fontsize=24, fontweight="bold")
plt.suptitle(suptitle, fontsize=16, style="italic")
plt.axis("off")
plt.legend(scatterpoints=1, loc='best', fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("graph_77.pdf", bbox_inches="tight")
