
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import networkx as nx
import numpy as np
import random

# Media network nodes and connections
random.seed(79)
np.random.seed(79)

# Creating a random media network graph with 12 nodes (e.g., media outlets or articles)
G = nx.erdos_renyi_graph(12, 0.3)
weights = {edge: np.random.randint(1, 10) for edge in G.edges()}
nx.set_edge_attributes(G, weights, "weight")

# Use a spring layout for node positions
pos = nx.spring_layout(G, seed=79)

# Labels for media nodes
labels = {
    0: "Media 0", 1: "Media 1", 2: "Media 2", 3: "Media 3",
    4: "Media 4", 5: "Media 5", 6: "Media 6", 7: "Media 7",
    8: "Media 8", 9: "Media 9", 10: "Media 10", 11: "Media 11"
}

# Draw edge labels
edge_labels = nx.get_edge_attributes(G, "weight")

# Chart title
title = "Media Network Analysis"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(14, 10))

# Draw nodes with media color theme
nx.draw(
    G, pos, node_size=800, node_color="tan", edge_color="gray", with_labels=False
)

# Draw the labels for the media nodes
nx.draw_networkx_labels(
    G, pos, labels=labels, font_color="black", font_size=12, font_weight="bold"
)

# Draw the edges with varying widths based on media edge weights
nx.draw_networkx_edges(
    G, pos, width=[weights[edge] * 0.5 for edge in G.edges()], style="dashed", edge_color="darkgoldenrod"
)

# Draw edge labels with connection importance
nx.draw_networkx_edge_labels(
    G, pos, edge_labels=edge_labels, font_color="brown", font_size=10
)

# Add a title and configure layout
plt.title(title, size=20, fontweight='bold')
plt.tight_layout()

# ===================
# Part 4: Saving Output
# ===================
# Save the plot
plt.savefig("graph_79.pdf", bbox_inches="tight")
