

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.colors import LogNorm

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generating plausible data for agricultural yields of various crops over 12 months
Z = np.random.randint(20, 200, size=(6, 12))

titles = ["Monthly Crop Yields: No Edges", "Monthly Crop Yields: Thick Edges"]
xlabel = "Months"
ylabel = ["Wheat", "Corn", "Rice", "Barley", "Soybeans", "Sunflower"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, (ax0, ax1) = plt.subplots(2, 1, figsize=(8, 6))

# First subplot without edges
c0 = ax0.pcolor(Z, cmap="viridis")
ax0.set_title(titles[0])
ax0.set_xlabel(xlabel)
ax0.set_yticks(np.arange(0.5, len(ylabel), 1))
ax0.set_yticklabels(ylabel)
fig.colorbar(c0, ax=ax0)

# Second subplot with thick edges
c1 = ax1.pcolor(Z, edgecolors="w", linewidths=2, cmap="viridis")
ax1.set_title(titles[1])
ax1.set_xlabel(xlabel)
ax1.set_yticks(np.arange(0.5, len(ylabel), 1))
ax1.set_yticklabels(ylabel)
fig.colorbar(c1, ax=ax1)

# ===================
# Part 4: Saving Output
# ===================
fig.tight_layout()
plt.savefig("heatmap_110.pdf", bbox_inches="tight")
