# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# New data
cities = ["City H", "City I", "City J", "City K", "City L", "City M", "City N"]
months = [
    "Jan",
    "Feb",
    "Mar",
    "Apr",
    "May",
    "Jun",
    "Jul",
    "Aug",
    "Sep",
    "Oct",
    "Nov",
    "Dec",
]

# Simulating average monthly Air Quality Index (AQI)
aqi_values = np.array(
    [
        [85, 75, 70, 65, 60, 55, 50, 55, 60, 65, 75, 80],
        [90, 80, 75, 70, 65, 60, 55, 60, 65, 70, 80, 85],
        [95, 85, 80, 75, 70, 65, 60, 65, 70, 75, 85, 90],
        [100, 90, 85, 80, 75, 70, 65, 70, 75, 80, 90, 95],
        [105, 95, 90, 85, 80, 75, 70, 75, 80, 85, 95, 100],
        [110, 100, 95, 90, 85, 80, 75, 80, 85, 90, 100, 105],
        [115, 105, 100, 95, 90, 85, 80, 85, 90, 95, 105, 110],
    ]
)

title = "Average Monthly AQI in Various Cities"
xlabel = "Months"
ylabel = "Cities"

cbar_label = "AQI"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 7))

im = ax.imshow(aqi_values, cmap="coolwarm")

# Show all ticks and label them with the respective list entries
ax.set_xticks(np.arange(len(months)), labels=months)
ax.set_yticks(np.arange(len(cities)), labels=cities)

# Rotate the tick labels and set their alignment
plt.setp(ax.get_xticklabels(), rotation=45, ha="right", rotation_mode="anchor")

# Loop over data dimensions and create text annotations
for i in range(len(cities)):
    for j in range(len(months)):
        text = ax.text(j, i, aqi_values[i, j], ha="center", va="center", color="black")

ax.set_title(title)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

# Add a colorbar
cbar = ax.figure.colorbar(im, ax=ax)
cbar.ax.set_ylabel(cbar_label, rotation=-90, va="bottom")

# ===================
# Part 4: Saving Output
# ===================
fig.tight_layout()
plt.savefig("heatmap_112.pdf", bbox_inches="tight")
