
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# New data for psychology domain
activities = ["Reading", "Writing", "Exercising", "Meditation", "Socializing", "Working", "Sleeping"]
participants = [
    "Participant 1",
    "Participant 2",
    "Participant 3",
    "Participant 4",
    "Participant 5",
    "Participant 6",
    "Participant 7",
]

# Stress level data on a scale from 0 to 100
stress_levels = np.array(
    [
        [55, 70, 45, 30, 65, 80, 20],
        [65, 30, 75, 40, 50, 90, 25],
        [35, 60, 25, 50, 45, 95, 20],
        [70, 40, 30, 20, 75, 45, 15],
        [50, 55, 35, 45, 60, 85, 30],
        [45, 20, 40, 35, 55, 70, 50],
        [30, 50, 30, 45, 35, 60, 25],
    ]
)

title = "Stress Levels of Participants Across Various Activities"
xlabel = "Participants"
ylabel = "Activities"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 8))

im = ax.imshow(stress_levels, cmap="viridis")

# Show all ticks and label them with the respective list entries
ax.set_xticks(np.arange(len(participants)), labels=participants)
ax.set_yticks(np.arange(len(activities)), labels=activities)

# Rotate the tick labels and set their alignment.
plt.setp(ax.get_xticklabels(), rotation=45, ha="right", rotation_mode="anchor")

# Loop over data dimensions and create text annotations.
for i in range(len(activities)):
    for j in range(len(participants)):
        text = ax.text(j, i, stress_levels[i, j], ha="center", va="center", color="white")

ax.set_title(title)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

# ===================
# Part 4: Saving Output
# ===================
fig.tight_layout()
plt.savefig("heatmap_113.pdf", bbox_inches="tight")
