
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.colors as mcolors

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# Data in the heatmap: [artworks, visitors, artist_talks, workshops, social_media_mentions, online_views]
data = np.array(
    [
        [50, 2000, 5, 10, 1000, 3000],
        [45, 1800, 4, 8, 900, 2700],
        [55, 2100, 6, 12, 1100, 3200],
        [48, 1950, 5, 9, 950, 2900],
        [52, 2050, 5, 11, 1050, 3100],
    ]
)

# Labels for rows and columns
row_labels = ["Exhibition A", "Exhibition B", "Exhibition C", "Exhibition D", "Exhibition E"]
column_labels = ["Artworks", "Visitors", "Artist Talks", "Workshops", "Social Media Mentions", "Online Views"]
title = "Art Exhibition Metrics"
xlabel = "Metrics"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Initialize the matplotlib figure
f, ax = plt.subplots(figsize=(10, 7))

# Define a vibrant colormap
vibrant_cmap = [
    "#FF6361", "#FFA600", "#BC5090", "#58508D", "#003F5C", "#00CC96", "#2E91E5"
]
cmap = mcolors.LinearSegmentedColormap.from_list("vibrant_cmap", vibrant_cmap)

# Draw the heatmap
cax = ax.imshow(data, cmap=cmap)

# Set the title
ax.set_title(title, fontsize=20, fontweight='bold')

# Set labels for axes
ax.set_xlabel(xlabel, fontsize=16)
ax.set_xticks(range(len(column_labels)))
ax.set_xticklabels(column_labels, fontsize=14)
ax.set_yticks(range(len(row_labels)))
ax.set_yticklabels(row_labels, fontsize=14, rotation=0)

# Increase font size of the tick labels
ax.tick_params(axis="both", which="major", labelsize=14)

# Add the text annotations
for i in range(len(row_labels)):
    for j in range(len(column_labels)):
        text = ax.text(
            j, i, data[i, j], ha="center", va="center", color="white", fontsize=14, fontweight='bold'
        )

# Create colorbar
cbar = f.colorbar(cax, ax=ax)
cbar.ax.tick_params(labelsize=14)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to fit the figure size
plt.tight_layout()

# Show the plot
plt.savefig("heatmap_34.pdf", bbox_inches="tight")
