# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import pandas as pd

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
categories = [
    "Temperature",
    "Precipitation",
    "Elevation",
    "Humidity",
    "Wind Speed",
    "Solar Radiation",
]

# Generating random data for illustration purposes in the geography domain
data = np.random.uniform(size=(180,))  # 180 values for 6 categories, 30 values each

# Creating a DataFrame
df = pd.DataFrame(
    {
        "Categories": np.tile(categories, 30),  # Repeating each category 30 times
        "Count": np.repeat(range(30), 6),  # Repeating each number from 0-29, 6 times
        "Values": data,
    }
)

# Pivoting the DataFrame to get it into the matrix form
pivot_df = df.pivot(index="Categories", columns="Count", values="Values")

# Reordering the index of the pivot_df to match the desired order
pivot_df = pivot_df.reindex(categories)

xlabel = "Time Points"
ylabel = "Geographical Metrics"
title = "Geographical Metrics Over Time"
cbar_label = "Value Intensity"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the heatmap with categories on the y-axis
plt.figure(figsize=(8, 4))  # Adjust size as needed

cax = plt.imshow(pivot_df, cmap="Blues", aspect="auto")

# Set x-ticks to be at specific intervals
plt.xticks(np.arange(0, 30, 5), range(0, 30, 5))
plt.yticks(range(len(categories)), categories)
plt.xlabel(xlabel, fontsize=12)
plt.ylabel(ylabel, fontsize=12)
plt.title(title, fontsize=14)

# Ensure y-tick labels are horizontal
plt.yticks(rotation=0)
# Ensure x-tick labels are horizontal
plt.xticks(rotation=0)

# Add colorbar with label
cbar = plt.colorbar(cax)
cbar.set_label(cbar_label, rotation=270, labelpad=15, fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("heatmap_42.pdf", bbox_inches="tight")
