

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Placeholder data for confusion matrices in Environmental Science
data_air_quality = np.array([[40, 5, 3, 2], [8, 37, 3, 2], [2, 6, 30, 7], [1, 1, 4, 41]])
data_water_pollution = np.array([[35, 10, 3, 2], [5, 40, 3, 2], [2, 7, 25, 11], [1, 0, 5, 44]])
data_soil_erosion = np.array([[32, 12, 5, 1], [7, 33, 4, 6], [3, 5, 27, 11], [2, 2, 3, 43]])
data_biodiversity = np.array([[37, 8, 2, 3], [6, 35, 5, 4], [1, 6, 29, 10], [0, 1, 4, 45]])
data_deforestation = np.array([[33, 10, 4, 3], [5, 32, 7, 6], [2, 6, 28, 9], [1, 0, 3, 46]])
data_climate_change = np.array([[34, 9, 3, 4], [6, 29, 8, 7], [3, 7, 26, 9], [2, 1, 4, 43]])
data_waste_management = np.array([[38, 8, 2, 2], [7, 34, 4, 3], [1, 5, 30, 9], [0, 1, 5, 44]])
data_renewable_energy = np.array([[39, 7, 1, 3], [6, 36, 3, 3], [2, 6, 28, 9], [1, 0, 4, 46]])

# Titles for the subplots
titles = ["Air Quality", "Water Pollution", "Soil Erosion", "Biodiversity", "Deforestation", "Climate Change", "Waste Management", "Renewable Energy"]
xlabel = "Predicted Condition"
ylabel = "Actual Condition"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, axes = plt.subplots(nrows=2, ncols=4, figsize=(14, 8))  # Adjusted for better spacing

# Function to create a single confusion matrix plot
def plot_confusion_matrix(ax, data, title):
    im = ax.imshow(data, interpolation="nearest", cmap="Blues")
    ax.figure.colorbar(im, ax=ax)
    ax.set(
        title=title,
        xlabel=xlabel,
        ylabel=ylabel,
        xticks=np.arange(data.shape[1]),
        yticks=np.arange(data.shape[0]),
    )
    # Loop over data dimensions and create text annotations.
    for i in range(data.shape[0]):
        for j in range(data.shape[1]):
            ax.text(j, i, data[i, j], ha="center", va="center", color="black", fontsize=10)

# Plot each confusion matrix
plot_confusion_matrix(axes[0, 0], data_air_quality, titles[0])
plot_confusion_matrix(axes[0, 1], data_water_pollution, titles[1])
plot_confusion_matrix(axes[0, 2], data_soil_erosion, titles[2])
plot_confusion_matrix(axes[0, 3], data_biodiversity, titles[3])
plot_confusion_matrix(axes[1, 0], data_deforestation, titles[4])
plot_confusion_matrix(axes[1, 1], data_climate_change, titles[5])
plot_confusion_matrix(axes[1, 2], data_waste_management, titles[6])
plot_confusion_matrix(axes[1, 3], data_renewable_energy, titles[7])

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit and save the figure
plt.tight_layout()
plt.savefig("heatmap_43.pdf", bbox_inches="tight")

