
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Placeholder data for confusion matrices (energy sector)
data_solar = np.array([[60, 5, 8, 2], [6, 55, 3, 6], [4, 3, 45, 8], [3, 5, 6, 50]])
data_wind = np.array([[70, 10, 5, 5], [7, 65, 8, 5], [5, 8, 55, 5], [3, 7, 8, 62]])
data_hydro = np.array([[50, 5, 10, 5], [8, 45, 5, 10], [7, 5, 40, 5], [4, 6, 5, 55]])
data_nuclear = np.array([[65, 8, 6, 5], [5, 60, 8, 7], [4, 7, 50, 6], [5, 6, 9, 58]])
data_coal = np.array([[55, 7, 5, 5], [6, 50, 7, 8], [5, 6, 48, 7], [3, 4, 7, 50]])
data_natural_gas = np.array([[60, 5, 7, 4], [5, 55, 6, 7], [6, 8, 50, 8], [4, 5, 6, 60]])
data_geothermal = np.array([[70, 8, 6, 3], [6, 65, 7, 6], [7, 6, 55, 8], [5, 7, 6, 58]])
data_biomass = np.array([[65, 10, 6, 4], [8, 60, 7, 5], [4, 5, 50, 6], [3, 6, 7, 55]])

# Titles for the subplots
titles = ["Solar", "Wind", "Hydro", "Nuclear", "Coal", "Natural Gas", "Geothermal", "Biomass"]
xlabel = "Predicted Category"
ylabel = "True Category"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, axes = plt.subplots(nrows=2, ncols=4, figsize=(14, 7))  # Adjusted for better fit

# New colormap for a vibrant energy theme
cmap = plt.cm.plasma

# Function to create a single confusion matrix plot
def plot_confusion_matrix(ax, data, title):
    im = ax.imshow(data, interpolation="nearest", cmap=cmap)
    ax.figure.colorbar(im, ax=ax)
    ax.set(
        title=title,
        xlabel=xlabel,
        ylabel=ylabel,
        xticks=np.arange(data.shape[1]),
        yticks=np.arange(data.shape[0]),
    )
    # Loop over data dimensions and create text annotations.
    for i in range(data.shape[0]):
        for j in range(data.shape[1]):
            ax.text(j, i, data[i, j], ha="center", va="center", color="white")

# Plot each confusion matrix
plot_confusion_matrix(axes[0, 0], data_solar, titles[0])
plot_confusion_matrix(axes[0, 1], data_wind, titles[1])
plot_confusion_matrix(axes[0, 2], data_hydro, titles[2])
plot_confusion_matrix(axes[0, 3], data_nuclear, titles[3])
plot_confusion_matrix(axes[1, 0], data_coal, titles[4])
plot_confusion_matrix(axes[1, 1], data_natural_gas, titles[5])
plot_confusion_matrix(axes[1, 2], data_geothermal, titles[6])
plot_confusion_matrix(axes[1, 3], data_biomass, titles[7])

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit and save the figure
plt.tight_layout()
plt.savefig("heatmap_44.pdf", bbox_inches="tight")
