# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(2)  # Using a different seed for new data

# Placeholder data for population demographics interactions in communities
data_community_1 = np.array(
    [[30, 14, 5, 1], [12, 28, 20, 6], [5, 18, 40, 7], [2, 6, 9, 33]]
)
data_community_2 = np.array(
    [[25, 10, 7, 3], [10, 30, 15, 5], [6, 14, 32, 8], [1, 5, 11, 37]]
)
data_community_3 = np.array(
    [[28, 12, 6, 4], [11, 26, 18, 7], [4, 16, 35, 5], [3, 7, 8, 39]]
)
data_community_4 = np.array(
    [[32, 13, 4, 2], [13, 25, 21, 3], [5, 15, 38, 6], [2, 8, 10, 36]]
)

# Titles for the subplots
titles = ["Community 1", "Community 2", "Community 3", "Community 4"]
xlabel = "Predicted Age Group"
ylabel = "True Age Group"

xticklabels = ["Children", "Teenagers", "Adults", "Seniors"]
ytitcklabels = ["Children", "Teenagers", "Adults", "Seniors"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, axes = plt.subplots(
    nrows=1, ncols=4, figsize=(16, 4)
)  # Adjusted for a single row layout

# Updated color map and annotations
cmap = "coolwarm"


# Function to create a single confusion matrix plot
def plot_confusion_matrix(ax, data, title):
    im = ax.imshow(data, interpolation="nearest", cmap=cmap)
    ax.figure.colorbar(im, ax=ax)
    ax.set(
        title=title,
        xlabel=xlabel,
        ylabel=ylabel,
        xticks=np.arange(data.shape[1]),
        yticks=np.arange(data.shape[0]),
    )
    ax.set_xticklabels(xticklabels, rotation=45, ha="right")
    ax.set_yticklabels(ytitcklabels)
    # Loop over data dimensions and create text annotations.
    for i in range(data.shape[0]):
        for j in range(data.shape[1]):
            ax.text(
                j,
                i,
                data[i, j],
                ha="center",
                va="center",
                color="black",
                fontsize=8,
                fontweight="bold",
            )


# Plot each confusion matrix
plot_confusion_matrix(axes[0], data_community_1, titles[0])
plot_confusion_matrix(axes[1], data_community_2, titles[1])
plot_confusion_matrix(axes[2], data_community_3, titles[2])
plot_confusion_matrix(axes[3], data_community_4, titles[3])


# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit and save the figure
plt.tight_layout()
plt.savefig("heatmap_45.pdf", bbox_inches="tight")
