
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data (fictional media consumption correlations, 2D array)
data = np.array(
    [
        [np.nan, np.nan, np.nan, np.nan, np.nan, np.nan, np.nan, np.nan],
        [0.60, np.nan, np.nan, np.nan, np.nan, np.nan, np.nan, np.nan],
        [0.25, 0.70, np.nan, np.nan, np.nan, np.nan, np.nan, np.nan],
        [0.15, 0.20, 0.65, np.nan, np.nan, np.nan, np.nan, np.nan],
        [0.30, 0.55, 0.35, 0.40, np.nan, np.nan, np.nan, np.nan],
        [0.20, 0.40, 0.50, 0.60, 0.45, np.nan, np.nan, np.nan],
        [0.10, 0.30, 0.25, 0.35, 0.50, 0.55, np.nan, np.nan],
        [0.05, 0.25, 0.20, 0.30, 0.40, 0.45, 0.50, np.nan],
    ]
)

events = [
    "News",
    "Reality TV",
    "Documentaries",
    "Movies",
    "TV Shows",
    "Video Games",
    "Streaming Services",
    "Social Media",
]

# Text label parameters
xlabel = "Media Types"
ylabel = "Media Types"
title = "Correlation Between Media Consumption Types"
suptitle = "A Comprehensive Overview of Media Consumption Trends"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(9, 7))

# Create heatmap with a warm color scheme
cax = ax.matshow(data, cmap="YlOrBr")

# Add color bar
plt.colorbar(cax)

# Set axis labels 
ax.set_xticks(np.arange(len(events)))
ax.set_yticks(np.arange(len(events)))
ax.set_xticklabels(events)
ax.set_yticklabels(events)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

# Rotate the tick labels bottom and rotated to 45 degrees
ax.xaxis.set_ticks_position("bottom")
ax.xaxis.set_tick_params(rotation=45)

# Loop over data dimensions and create text annotations
for i in range(len(events)):
    for j in range(len(events)):
        if not np.isnan(data[i, j]):
            text_color = "white" if data[i, j] > 0.30 else "black"
            text = ax.text(j, i, f"{data[i, j]:.2f}", ha="center", va="center", color=text_color)

ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["left"].set_visible(False)
ax.spines["bottom"].set_visible(False)

# Add titles
plt.title(title, pad=20)
plt.suptitle(suptitle, fontsize=14, y=1.05)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("heatmap_52.pdf", bbox_inches="tight")
