
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Data for the new domain: financial metrics
data = np.array(
    [
        [np.nan, np.nan, np.nan, np.nan, np.nan, np.nan, np.nan, np.nan],
        [0.35, np.nan, np.nan, np.nan, np.nan, np.nan, np.nan, np.nan],
        [0.45, 0.70, np.nan, np.nan, np.nan, np.nan, np.nan, np.nan],
        [0.55, 0.65, 0.75, np.nan, np.nan, np.nan, np.nan, np.nan],
        [0.50, 0.60, 0.80, 0.70, np.nan, np.nan, np.nan, np.nan],
        [0.40, 0.45, 0.65, 0.60, 0.55, np.nan, np.nan, np.nan],
        [-0.20, 0.25, 0.20, 0.30, 0.35, 0.30, np.nan, np.nan],
        [0.10, 0.50, 0.60, 0.55, 0.65, 0.55, 0.45, np.nan],
    ]
)

metrics = [
    "Revenue Growth",
    "Profit Margin",
    "Debt to Equity",
    "Return on Assets",
    "Operating Cash Flow",
    "Earnings Per Share",
    "Dividend Yield",
    "Price to Earnings Ratio",
]

title = "Correlation Among Financial Metrics"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(8, 6))

# Create heatmap
cax = ax.matshow(data, cmap="Greens")

# Add color bar
plt.colorbar(cax)

# Set axis labels
ax.set_xticks(np.arange(len(metrics)))
ax.set_yticks(np.arange(len(metrics)))
ax.set_xticklabels(metrics)
ax.set_yticklabels(metrics)

# Rotate the tick labels bottom and rotated to 90
ax.xaxis.set_ticks_position("bottom")
ax.xaxis.set_tick_params(rotation=90)

# Loop over data dimensions and create text annotations
for i in range(len(metrics)):
    for j in range(len(metrics)):
        if not np.isnan(data[i, j]):
            if data[i, j] > 0.25:
                text = ax.text(
                    j, i, f"{data[i, j]:.2f}", ha="center", va="center", color="white"
                )
            else:
                text = ax.text(
                    j, i, f"{data[i, j]:.2f}", ha="center", va="center", color="black"
                )

# Add titles and labels
plt.title(title, pad=20)

ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["left"].set_visible(False)
ax.spines["bottom"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("heatmap_53.pdf", bbox_inches="tight")
