# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Sample political data for demonstration
data_upper = (
    np.random.rand(9, 16) * 100
)  # Data for voter turnout trends (upper subplot)
data_lower = (
    np.random.rand(9, 16) * 100
)  # Data for policy approval ratings (lower subplot)

# Common labels for both subplots
political_terms = [
    "Election Q1",
    "Election Q2",
    "Election Q3",
    "Election Q4",
    "Healthcare Policy",
    "Education Policy",
    "Defense Policy",
    "Economic Policy",
    "Environmental Policy",
]
time_periods = list(range(16))

# Axes Limits and Labels
title = "Political Metrics Analysis (Election Quarters)"
xlabel_value = "Time Periods"
xticks_values = [0, 4, 8, 12, 15]
xticklabels = ["Start", "Q1", "Q2", "Q3", "Q4"]
yticks_values = range(len(political_terms))
ax1_title = "Voter Turnout Trends"
cbar_titles = ["Voter Turnout (%)", "Approval Rating (%)"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and two subplots
fig, (ax1, ax2) = plt.subplots(
    2, 1, figsize=(10, 8)
)  # Adjust figsize for better readability

# Define a new color map
cmap_upper = plt.get_cmap("Greens")
cmap_lower = plt.get_cmap("Blues")

# First subplot - Voter Turnout Trends
im1 = ax1.imshow(data_upper, cmap=cmap_upper, aspect="auto")
ax1.set_title(ax1_title)
ax1.set_yticks(range(len(political_terms)))
ax1.set_yticklabels(political_terms)
ax1.grid(True, linestyle="--", linewidth=0.5)

# Second subplot - Policy Approval Ratings
im2 = ax2.imshow(data_lower, cmap=cmap_lower, aspect="auto")
ax2.set_xlabel(xlabel_value)
ax2.set_xticks(xticks_values)
ax2.set_xticklabels(xticklabels)
ax2.set_yticks(yticks_values)
ax2.set_yticklabels(political_terms)
ax2.grid(True, linestyle="--", linewidth=0.5)

# Add colorbars
cbar1 = fig.colorbar(im1, ax=ax1, orientation="vertical", fraction=0.046, pad=0.04)
cbar1.set_label(cbar_titles[0])
cbar2 = fig.colorbar(im2, ax=ax2, orientation="vertical", fraction=0.046, pad=0.04)
cbar2.set_label(cbar_titles[1])

# ===================
# Part 4: Saving Output
# ===================
# Show the entire figure with tight layout to minimize white space
plt.tight_layout()
plt.savefig("heatmap_57.pdf", bbox_inches="tight")
