

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# New data for society-related metrics
data_region1 = np.array(
    [
        [50, 10, 20, 5, 0, 0],
        [20, 40, 10, 10, 5, 0],
        [10, 15, 30, 10, 5, 0],
        [5, 5, 10, 35, 10, 10],
        [0, 5, 10, 15, 30, 10],
        [0, 0, 0, 10, 20, 25],
    ]
)
data_region2 = np.array(
    [
        [10, 5, 0, 10, 5, 0],
        [5, 10, 10, 15, 10, 5],
        [5, 0, 20, 10, 15, 15],
        [15, 10, 5, 5, 10, 10],
        [10, 15, 5, 5, 20, 15],
        [15, 20, 25, 5, 10, 10],
    ]
)

# Titles for the subplots
titles = ["Region 1 Metrics", "Region 2 Metrics"]
ylabel = "Region"
xlabel = "Societal Metric"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Increase the figure height and adjust subplot layout
fig, axes = plt.subplots(nrows=1, ncols=2, figsize=(6, 5))

# Function to create a single confusion matrix plot
def plot_confusion_matrix(ax, data, title):
    im = ax.imshow(data, interpolation="nearest", cmap="Blues")
    ax.set(
        title=title,
        ylabel=ylabel,
        xlabel=xlabel,
        xticks=np.arange(data.shape[1]),
        yticks=np.arange(data.shape[0]),
    )
    ax.axhline(y=2.5, color="black", linewidth=2.5, linestyle='--')
    ax.axvline(x=2.5, color="black", linewidth=2.5, linestyle='--')
    # unset the ticks
    ax.set_xticks([])
    ax.set_yticks([])
    # unset the spines
    ax.spines["top"].set_visible(False)
    ax.spines["right"].set_visible(False)
    ax.spines["bottom"].set_visible(False)
    ax.spines["left"].set_visible(False)
    return im

# Plot each confusion matrix
im1 = plot_confusion_matrix(axes[0], data_region1, titles[0])
im2 = plot_confusion_matrix(axes[1], data_region2, titles[1])

# Adjust the position and size of the colorbars
cbar_ax1 = fig.add_axes([0.05, 0.15, 0.45, 0.02])  # Adjusted for the first subplot
cbar_ax2 = fig.add_axes([0.55, 0.15, 0.45, 0.02])  # Adjusted for the second subplot
fig.colorbar(im1, cax=cbar_ax1, orientation="horizontal")
fig.colorbar(im2, cax=cbar_ax2, orientation="horizontal")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
fig.tight_layout()
plt.savefig("heatmap_64.pdf", bbox_inches="tight")
