

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# New dataset representing performance ratings across business metrics
data = np.array(
    [
        [75, 80, 85, 90],
        [88, 82, np.nan, 91],
        [np.nan, 77, 80, 85],
        [70, np.nan, 78, 83],
    ]
)
xticklabels = ["Q1", "Q2", "Q3", "Q4"]
yticklabels = ["Sales", "Marketing", "HR", "R&D"]

xlabel = "Quarters"
ylabel = "Departments"
title = "Quarterly Performance Ratings"
suptitle = "Business Performance Analysis"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a heatmap, setting NaN values' color to grey
cmap = plt.cm.coolwarm
cmap.set_bad("gray", 1.0)

# Draw the heatmap
fig, ax = plt.subplots(figsize=(8, 8))
cax = ax.matshow(data, cmap=cmap)

# Add text
for (i, j), val in np.ndenumerate(data):
    if not np.isnan(val):  # Only add text for non-NaN values
        ax.text(j, i, f"{val}%", va="center", ha="center", color="black", fontsize=12)

# Set axis labels.
ax.set_xticks(np.arange(data.shape[1]))
ax.set_yticks(np.arange(data.shape[0]))

# Set axis tick labels
ax.set_xticklabels(xticklabels, fontsize=12)
ax.set_yticklabels(yticklabels, fontsize=12)

# Set axis labels
ax.set_xlabel(xlabel, fontsize=14)
ax.set_ylabel(ylabel, fontsize=14)

# Set Title
plt.title(title, pad=20, fontsize=16)
plt.suptitle(suptitle, fontsize=18)

# Turn off the gridlines generated by the ticks
ax.grid(False)

# ===================
# Part 4: Saving Output
# ===================
# Display the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("heatmap_69.pdf", bbox_inches="tight")
