
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(2)

# Sample data for weather domain
data = np.random.rand(10, 5) * 30 - 10  # Random data simulating weather variations (temperature, rainfall, etc.)

cities = [
    "New York",
    "Los Angeles",
    "Chicago",
    "Houston",
    "Phoenix",
    "Philadelphia",
    "San Antonio",
    "San Diego",
    "Dallas",
    "San Jose",
]

metrics = ["Temperature", "Humidity", "Rainfall", "Wind Speed", "Visibility"]

# Text labels and titles
xlabel = 'Weather Metrics'
ylabel = 'Cities'
title = 'Weather Metrics for Various Cities'
cbar_label = 'Value Range'

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the heatmap
fig, ax = plt.subplots(figsize=(8, 10))  # Adjusting figure size

# Selecting a custom color map for weather domain
cax = ax.matshow(data, cmap="RdYlGn", vmin=-10, vmax=30)

# Set axis labels
ax.set_xticks(np.arange(len(metrics)))
ax.set_yticks(np.arange(len(cities)))
ax.set_xticklabels(metrics)
ax.set_yticklabels(cities)

# Rotate the tick labels and set their alignment
plt.setp(ax.get_xticklabels(), rotation=45, ha="right")

# Add colorbar with custom label
cbar = plt.colorbar(cax, aspect=10.5, pad=0.03)
cbar.set_label(cbar_label)

# Adding titles and labels
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title, pad=20)

# ===================
# Part 4: Saving Output
# ===================
# Showing the plot and saving as a PDF
plt.tight_layout()
plt.savefig("heatmap_71.pdf", bbox_inches="tight")
