
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Seed for reproducibility
np.random.seed(0)

# Sample data for Transportation domain
data = np.random.rand(10, 5) * 2 - 1  # Random data between -1 and 1
sectors = [
    "Highways",
    "Railways",
    "Airports",
    "Ports",
    "Public Transit",
    "Bike Lanes",
    "Pedestrian Paths",
    "Bridges",
    "Tunnels",
    "Parking Facilities",
]
vehicle_types = ["Cars", "Trains", "Planes", "Ships", "Bicycles"]

# Text label parameters
xlabel = "Vehicle Types"
ylabel = "Transportation Sectors"
title = "Impact of Vehicle Types on Transportation Sectors"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the heatmap
fig, ax = plt.subplots(figsize=(6, 10))  # Adjusting figure size
cax = ax.matshow(data, cmap="viridis", vmin=-1, vmax=1)

# Set axis labels
ax.set_xticks(np.arange(len(vehicle_types)))
ax.set_yticks(np.arange(len(sectors)))
ax.set_xticklabels(vehicle_types)
ax.set_yticklabels(sectors)

# Rotate the tick labels and set their alignment
plt.setp(ax.get_xticklabels(), rotation=270, ha="center")

# Add colorbar
cbar = plt.colorbar(cax, aspect=10.5)

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title, pad=20)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot
plt.tight_layout()
plt.savefig("heatmap_72.pdf", bbox_inches="tight")
