# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample environmental data representing increase in pollution levels (%) due to industrial activities over time
data = np.array(
    [
        [5, 15, 25, 35, 45, 55],
        [np.nan, 10, 20, 30, 40, 50],
        [np.nan, np.nan, 15, 25, 35, 45],
        [np.nan, np.nan, np.nan, 20, 30, 40],
        [np.nan, np.nan, np.nan, np.nan, 25, 35],
        [np.nan, np.nan, np.nan, np.nan, np.nan, 30],
    ]
)
colorbar_label = "Increase in Pollution Levels (%)"
xlabel = "Duration of Industrial Activity (years)"
ylabel = "Pollution Severity Level"
title = "Impact of Industrial Activities on Pollution"
textstr = "Study: Environmental Impact\nAverage Increase"
xticklabels = ["1", "2", "3", "4", "5", "6"]
yticklabels = ["Very Low", "Low", "Moderate", "High", "Very High", "Critical"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(8, 10))

# Create the heatmap
cax = ax.matshow(data, cmap="RdYlGn")

# Add colorbar
cbar = fig.colorbar(cax, label=colorbar_label, shrink=0.5)

# Set axis labels
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

# Set axis ticks
ax.set_xticks(np.arange(6))
ax.set_yticks(np.arange(6))
ax.set_xticklabels(xticklabels)
ax.set_yticklabels(yticklabels)

# Add text box
props = dict(
    boxstyle="round",
    facecolor="white",
    alpha=0.8,
)
ax.text(
    0.05,
    0.15,
    textstr,
    transform=ax.transAxes,
    fontsize=12,
    verticalalignment="top",
    bbox=props,
)

# Add title
plt.title(title, pad=20)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("heatmap_75.pdf", bbox_inches="tight")
