# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import pandas as pd

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Defining the categories
categories = ["Solar", "Wind", "Hydro", "Fossil Fuels"]

# Generating plausible energy data for 35 time periods
data = np.random.uniform(
    0, 100, size=(140,)
)  # 35 periods for 4 categories, 35 * 4 = 140 values

# Creating a DataFrame
df = pd.DataFrame(
    {
        "Categories": np.tile(categories, 35),  # Repeating each category 35 times
        "Count": np.repeat(range(0, 35), 4),  # Repeating each number from 0-34, 4 times
        "Values": data,
    }
)

# Pivoting the DataFrame to get it into the matrix form
pivot_df = df.pivot(index="Categories", columns="Count", values="Values")

# Reordering the index of the pivot_df to match the desired order
pivot_df = pivot_df.reindex(categories)

color_bar_label = "Energy Production Values"  # Label for the color bar

title = "Energy Production Indicators Over Time"
xlabel = "Time Period"
ylabel = "Energy Sources"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the heatmap with categories on the y-axis
plt.figure(figsize=(12, 4))  # Adjust size as needed

# Choose a different colormap, e.g., 'viridis'
cmap = plt.get_cmap("viridis")
cax = plt.imshow(pivot_df, cmap=cmap, aspect="auto")

# Configure x and y ticks
plt.xticks(np.arange(0, 35, 5), range(0, 35, 5))
plt.yticks(range(len(categories)), categories)

plt.yticks(rotation=0)  # Ensure y-tick labels are horizontal
plt.xticks(rotation=0)  # Ensure x-tick labels are horizontal

# Adding titles and labels
plt.title(title, fontsize=14)
plt.xlabel(xlabel, fontsize=12)
plt.ylabel(ylabel, fontsize=12)

# Add colorbar
cbar = plt.colorbar(cax)
cbar.set_label(color_bar_label)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("heatmap_79.pdf", bbox_inches="tight")
