

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import pandas as pd

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Defining the categories
categories = ["Ancient", "Medieval", "Renaissance", "Modern"]

# Generating new data representative of historical periods
data = np.random.uniform(size=(140,))  # 140 values for 4 categories, 35 values each

# Creating a DataFrame
df = pd.DataFrame(
    {
        "Categories": np.tile(categories, 35),  # Repeating each category 35 times
        "Count": np.repeat(range(0, 35), 4),  # Repeating each number from 0-34, 4 times
        "Values": data,
    }
)

# Pivoting the DataFrame to get it into the matrix form
pivot_df = df.pivot(index="Categories", columns="Count", values="Values")

# Reordering the index of the pivot_df to match the desired order
pivot_df = pivot_df.reindex(categories)

# Text/Label parameters
color_bar_label = "Frequency of Historical Periods"
xlabel = "Works"
ylabel = "Historical Periods"
title = "Heatmap of Historical Period Frequencies Across Works"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the heatmap with categories on the y-axis
plt.figure(figsize=(12, 4))  # Adjust size as needed

# Choose a different colormap, e.g., 'coolwarm'
cmap = plt.get_cmap("coolwarm")
cax = plt.imshow(pivot_df, cmap=cmap)

# Set x to be 0 5 10 15 20 25 30 35
plt.xticks(np.arange(0, 35, 5), range(0, 35, 5))
plt.yticks(range(len(categories)), categories)

plt.yticks(rotation=0)  # Ensure y-tick labels are horizontal
plt.xticks(rotation=0)  # Ensure x-tick labels are horizontal

# Add title and axis labels
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# Add colorbar
cbar = plt.colorbar(cax)
cbar.set_label(color_bar_label)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("heatmap_80.pdf", bbox_inches="tight")

