
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import pandas as pd

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Defining the categories
categories = ["Air Quality", "Water Quality", "Soil Health", "Biodiversity"]

# Generating random data for illustration purposes
# Simulating environmental data for 12 months
data = np.random.uniform(20, 100, size=(48,))  # Environmental metrics between 20 and 100 for 12 months

# Creating a DataFrame
df = pd.DataFrame(
    {
        "Categories": np.tile(categories, 12),  # Repeating each category 12 times
        "Month": np.repeat(range(1, 13), 4),    # Repeating month numbers from 1-12, 4 times
        "Metrics": data,
    }
)

# Pivoting the DataFrame to get it into matrix form
pivot_df = df.pivot(index="Categories", columns="Month", values="Metrics")

# Reordering the index of the pivot_df to match the desired order
pivot_df = pivot_df.reindex(categories)

color_bar_label = "Environmental Metric Score"  # Label for the color bar

# Text label parameters
xlabel = "Month"
ylabel = "Categories"
title = "Environmental Metrics Across Months"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(12, 4))  # Adjust size as needed

# Choosing a sports-themed colormap, e.g., 'plasma'
cmap = plt.get_cmap("plasma")
cax = plt.imshow(pivot_df, cmap=cmap)

# Setting x-ticks to 1, 2, ..., 12
plt.xticks(np.arange(0, 13, 1), range(1, 14, 1))
plt.yticks(range(len(categories)), categories)

plt.yticks(rotation=0)  # Ensure y-tick labels are horizontal
plt.xticks(rotation=0)  # Ensure x-tick labels are horizontal

# Add colorbar
cbar = plt.colorbar(cax)
cbar.set_label(color_bar_label)

# Adding title and labels
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("heatmap_81.pdf", bbox_inches="tight")
