
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Data for the heatmaps (Economic indicators for demonstration purposes)
data_gdp = np.random.rand(4, 4) * 10  # GDP growth in percentage
data_unemployment = np.random.rand(4, 4) * 10  # Unemployment rates in percentage
data_inflation = np.random.rand(4, 4) * 5  # Inflation rates in percentage
data_interest = np.random.rand(4, 4) * 5  # Interest rates in percentage

titles = ["GDP Growth", "Unemployment Rates", "Inflation Rates", "Interest Rates"]
fig_title = "Economic Indicators"

xticklabels = ["Country A", "Country B", "Country C", "Country D"]
yticklabels = ["2018", "2019", "2020", "2021"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with subplots
fig, axs = plt.subplots(2, 2, figsize=(10, 8))

# Function to add text annotations
def add_annotations(ax, data):
    for i in range(data.shape[0]):
        for j in range(data.shape[1]):
            ax.text(j, i, f"{data[i, j]:.2f}", ha="center", va="center", color="black")

# GDP Growth heatmap
im1 = axs[0, 0].imshow(data_gdp, cmap="Greens", vmin=0, vmax=10)
axs[0, 0].set_title(titles[0])
add_annotations(axs[0, 0], data_gdp)

# Unemployment Rates heatmap
im2 = axs[0, 1].imshow(data_unemployment, cmap="Blues", vmin=0, vmax=10)
axs[0, 1].set_title(titles[1])
add_annotations(axs[0, 1], data_unemployment)

# Inflation Rates heatmap
im3 = axs[1, 0].imshow(data_inflation, cmap="Purples", vmin=0, vmax=5)
axs[1, 0].set_title(titles[2])
add_annotations(axs[1, 0], data_inflation)

# Interest Rates heatmap
im4 = axs[1, 1].imshow(data_interest, cmap="Reds", vmin=0, vmax=5)
axs[1, 1].set_title(titles[3])
add_annotations(axs[1, 1], data_interest)

# Adjust layout and add overall title
fig.suptitle(fig_title, fontsize=20)

# Set tick labels
for ax in axs.flat:
    ax.set_xticks(np.arange(4))
    ax.set_yticks(np.arange(4))
    ax.set_xticklabels(xticklabels)
    ax.set_yticklabels(yticklabels)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to minimize white space
plt.tight_layout(rect=[0, 0.03, 1, 0.95])
# Save the figure to a file
plt.savefig("heatmap_83.pdf", bbox_inches="tight")

