
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import pandas as pd

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Define the financial metrics labels
financial_metrics = [
    "Revenue",
    "Expenses",
    "Profit",
    "Investments",
    "Assets",
    "Liabilities",
    "Equity",
    "Cash Flow",
]

# Define the data for Year 2020 and Year 2021
year_2020_values = [500, 200, 300, 150, 700, 400, 300, 100]
year_2021_values = [550, 210, 340, 160, 750, 420, 330, 120]
titles = ["Year 2020", "Year 2021"]

xlabel = "Financial Metrics"
ylabel = ""
annotation_color = "black"
supertitle = "Financial Metrics Comparison: 2020 vs 2021"
colormap = "YlGnBu"  # Chosen for consistency

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with two subplots (one for Year 2020 and one for Year 2021)
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(10, 5))

# Define the color palette
cmap = plt.get_cmap(colormap)

# Plot heatmap for Year 2020 values
im1 = ax1.imshow(pd.DataFrame([year_2020_values], columns=financial_metrics), cmap=cmap)
ax1.set_title(titles[0])
ax1.set_xticks(range(len(financial_metrics)))
ax1.set_xticklabels(financial_metrics, rotation=45, ha="center")
ax1.set_yticks(range(1))
ax1.set_yticklabels([ylabel], rotation=0)

# Add annotations for Year 2020 values
for i in range(1):
    for j in range(len(financial_metrics)):
        ax1.text(
            j, i, f"{year_2020_values[j]:.2f}", ha="center", va="center", color=annotation_color
        )

# Plot heatmap for Year 2021 values
im2 = ax2.imshow(pd.DataFrame([year_2021_values], columns=financial_metrics), cmap=cmap)
ax2.set_title(titles[1])
ax2.set_xticks(range(len(financial_metrics)))
ax2.set_xticklabels(financial_metrics, rotation=45, ha="center")
ax2.set_yticks(range(1))
ax2.set_yticklabels([ylabel], rotation=0)

# Add annotations for Year 2021 values
for i in range(1):
    for j in range(len(financial_metrics)):
        ax2.text(
            j, i, f"{year_2021_values[j]:.2f}", ha="center", va="center", color=annotation_color
        )

# Display the figure
plt.subplots_adjust(hspace=0.4)
plt.suptitle(supertitle)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout(rect=[0, 0, 1, 0.96])
plt.savefig("heatmap_88.pdf", bbox_inches="tight")
