

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import pandas as pd

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Creating a new dataset related to health, representing ranks of different health indicators for various countries
data_health = {
    "Country": ["USA", "Germany", "China", "India"],
    "Life Expectancy Rank": ["#35", "#22", "#51", "#125"],
    "Hospital Beds Rank": ["#13", "#10", "#86", "#154"],
    "Mortality Rate Rank": ["#46", "#30", "#70", "#123"],
}

data_health_reversed = {
    "Country": ["India", "China", "Germany", "USA"],
    "Life Expectancy Rank": ["#125", "#51", "#22", "#35"],
    "Hospital Beds Rank": ["#154", "#86", "#10", "#13"],
    "Mortality Rate Rank": ["#123", "#70", "#30", "#46"],
}

# Convert to DataFrame
data_health_df = pd.DataFrame(data_health).set_index("Country")
data_health_reversed_df = pd.DataFrame(data_health_reversed).set_index("Country")

# Creating a function to convert the string indices to numeric values for plotting
def convert_to_numeric(cell):
    return int(cell.replace("#", ""))

# Convert the dataframes
data_health_numeric = data_health_df.applymap(convert_to_numeric)
data_health_reversed_numeric = data_health_reversed_df.applymap(convert_to_numeric)

# Axes Limits and Labels
ax1_title = "Health Indicators"
ax1_ylabel = "Countries"
ax2_title = "Reversed Health Indicators"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Creating the heatmap using matplotlib with increased linewidths for separation
fig, (ax1, ax2) = plt.subplots(
    ncols=2, figsize=(10, 5), gridspec_kw={"width_ratios": [1, 1], "wspace": 0.3}
)

# Setting a custom color map appropriate for the domain
cmap_custom1 = plt.get_cmap("YlGnBu")
cmap_custom2 = plt.get_cmap("YlOrRd")

# Heatmap for Health Indicators with increased cell borders
im1 = ax1.imshow(data_health_numeric, cmap=cmap_custom1)
ax1.set_title(ax1_title)
ax1.set_ylabel(ax1_ylabel)
ax1.set_xticks(range(len(data_health_df.columns)))
ax1.set_xticklabels(data_health_df.columns, rotation=45)
ax1.set_yticks(range(len(data_health_df.index)))
ax1.set_yticklabels(data_health_df.index, rotation=0)

# Add annotations for Health Indicators
for i in range(len(data_health_df.index)):
    for j in range(len(data_health_df.columns)):
        ax1.text(j, i, data_health_df.iloc[i, j], ha="center", va="center", color="black")

# Heatmap for Reversed Health Indicators with increased cell borders
im2 = ax2.imshow(data_health_reversed_numeric, cmap=cmap_custom2)
ax2.set_title(ax2_title)
ax2.set_xticks(range(len(data_health_reversed_df.columns)))
ax2.set_xticklabels(data_health_reversed_df.columns, rotation=45)
ax2.set_yticks(range(len(data_health_reversed_df.index)))
ax2.set_yticklabels(data_health_reversed_df.index, rotation=0)

# Add annotations for Reversed Health Indicators
for i in range(len(data_health_reversed_df.index)):
    for j in range(len(data_health_reversed_df.columns)):
        ax2.text(j, i, data_health_reversed_df.iloc[i, j], ha="center", va="center", color="black")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("heatmap_96.pdf", bbox_inches="tight")

