# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import pandas as pd

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Define the data for the adoption and obsolescence rates
adoption_rates = [0.65, 0.75, 0.80, 0.90, 0.50, 0.60, 0.85, 0.78]
obsolescence_rates = [0.20, 0.15, 0.10, 0.08, 0.35, 0.25, 0.10, 0.12]

# Text labels and parameters
titles = ["Adoption Rates", "Obsolescence Rates"]
xlabel = "Technologies"
ylabel = "Rates"
fig_suptitle = "Technology Adoption and Obsolescence Rates"

# Define figure labels for annotation
figure_labels = ["Tech " + str(i + 1) for i in range(len(adoption_rates))]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with two subplots (one for adoption and one for obsolescence rates)
fig, axs = plt.subplots(2, 1, figsize=(10, 4), sharex=True)
plt.suptitle(fig_suptitle)

# Define the color palettes
cmap_adoption = plt.get_cmap("Blues")
cmap_obsolescence = plt.get_cmap("Reds")

# Plot heatmap for adoption rates
im1 = axs[0].imshow(pd.DataFrame([adoption_rates], index=[""]), cmap=cmap_adoption)
axs[0].set_title(titles[0])
axs[0].set_xticks(range(len(figure_labels)))
axs[0].set_xticklabels(figure_labels)
axs[0].set_yticks([])

# Add annotations for adoption rates
for j in range(len(adoption_rates)):
    color = "white" if adoption_rates[j] > np.mean(adoption_rates) else "black"
    axs[0].text(j, 0, f"{adoption_rates[j]:.2f}", ha="center", va="center", color=color)

# Plot heatmap for obsolescence rates
im2 = axs[1].imshow(
    pd.DataFrame([obsolescence_rates], index=[""]), cmap=cmap_obsolescence
)
axs[1].set_title(titles[1])
axs[1].set_xticks(range(len(figure_labels)))
axs[1].set_xticklabels(figure_labels)
axs[1].set_yticks([])

# Add annotations for obsolescence rates
for j in range(len(obsolescence_rates)):
    color = "white" if obsolescence_rates[j] > np.mean(obsolescence_rates) else "black"
    axs[1].text(
        j, 0, f"{obsolescence_rates[j]:.2f}", ha="center", va="center", color=color
    )

# ===================
# Part 4: Saving Output
# ===================
# Display the figure with tight layout to minimize white space
plt.tight_layout(rect=[0, 0, 1, 0.96])  # Adjust rect to account for suptitle
plt.savefig("heatmap_99.pdf", bbox_inches="tight")
