# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)  # For reproducibility

# Simulating data for weather analysis
sizes = np.linspace(300, 100, 6, dtype=int)  # Generate sizes from 300 to 100
data = [
    np.random.normal(0, 5, size) for size in sizes
]  # Generate temperature deviations with mean 0 and stddev 5

# Labels for different cities
labels = [
    "City A",
    "City B",
    "City C",
    "City D",
    "City E",
    "City F",
]
xlabel = "Temperature Deviation (°C)"
ylabel = "Number of Readings"
xlim = [-15, 15]
xticks = [-15, -10, -5, 0, 5, 10, 15]
bins = 30
title = "Temperature Deviation Analysis Across Different Cities"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Histogram plot
colors = ["#72B7B2", "#FFB347", "#FF6961", "#AEC6CF", "#CFCFC4", "#77DD77"]

plt.figure(figsize=(10, 8))
plt.hist(
    data,
    bins=bins,
    stacked=True,
    edgecolor="white",
    linewidth=1.2,
    color=colors,
    label=labels,
    hatch="//",  # Adding hatch pattern for better visualization
)

# Set background color to white
ax = plt.gca()
ax.set_facecolor("white")

# Labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.xlim(xlim)
plt.xticks(xticks)
plt.title(title)
handles, labels = plt.gca().get_legend_handles_labels()

# Reverse handles and labels
handles = handles[::-1]
labels = labels[::-1]

plt.legend(handles, labels, loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Adjusting the plot to match the original image's dimensions
plt.tight_layout()
plt.savefig("hist_23.pdf", bbox_inches="tight")
