

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data for weather domain
city_a_temps = np.random.normal(15, 5, 1000)  # City A monthly average temperatures
city_b_temps = np.random.normal(20, 7, 1000)  # City B monthly average temperatures

# Define bins aligned for both histograms
bins = np.histogram(np.hstack((city_a_temps, city_b_temps)), bins=30)[1]
labels = ["City A", "City B"]
xlabel = "Temperature (°C)"
ylabel = "Number of Months"
title = "Distribution of Monthly Average Temperatures"
legendlabels = ["City A Temperatures", "City B Temperatures"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(6, 4))  # Adjusted to a slightly larger size for better clarity

# Plot histograms
ax.hist(
    city_a_temps,
    bins=bins,
    color="#76c893",  # Green color for City A
    edgecolor="#004d00",  # Dark green edges
    linewidth=1.2,
    label=legendlabels[0],
    align="mid",
    histtype="stepfilled",
    alpha=0.6,
)
ax.hist(
    city_b_temps,
    bins=bins,
    color="#d3a35d",  # Brown color for City B
    edgecolor="#7a3e00",  # Dark brown edges
    linewidth=1.2,
    label=legendlabels[1],
    align="mid",
    histtype="stepfilled",
    alpha=0.6,
)

# Set title and labels
ax.set_title(title)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

# Add grid for better readability
ax.grid(True, linestyle='--', alpha=0.5)

# Add legend
ax.legend()

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()

# Save the plot
plt.savefig("hist_30.pdf", bbox_inches="tight")

