

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Generate data for customer acquisition costs (CAC) for different advertising channels
social_media_cac = np.random.exponential(scale=50, size=1000)
search_engine_cac = np.random.exponential(scale=70, size=1000)

# Labels and other text
labels = ["Social Media CAC", "Search Engine CAC"]
xlabel = "Customer Acquisition Cost (USD)"
ylabel = "Frequency"
title = "Distribution of Customer Acquisition Costs"
bins = 40

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to a suitable dimension
plt.figure(figsize=(10, 6))

# Define colors
colors = ["#2ca02c", "#1f77b4"]  # Green for social media, Blue for search engine

# Plot histograms with stacked bars
plt.hist(
    [social_media_cac, search_engine_cac],
    bins=bins,
    stacked=True,
    label=labels,
    color=colors,
    edgecolor='black',  # Add edge color for better visual distinction
)

# Add labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)
plt.legend()

# Adjust x-axis range to match the data range
plt.xlim(left=plt.xlim()[0] + 0.1, right=400)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("hist_36.pdf", bbox_inches="tight")

