# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Generate new data for average daily screen time
# Simulating data: mean screen time is higher for teenagers with wider dispersion
teenagers_screen_time = np.random.normal(loc=300, scale=100, size=1000)
adults_screen_time = np.random.normal(loc=200, scale=50, size=1000)
labels = ["Teenagers", "Adults"]
xlabel = "Daily Screen Time (minutes)"
bins = 50
ylabel = "Number of Individuals"
title = "Average Daily Screen Time: Teenagers vs. Adults"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to an appropriate dimension
plt.figure(figsize=(8, 5))

# Plot histograms with stacked bars
plt.hist(
    [teenagers_screen_time, adults_screen_time],
    bins=bins,
    stacked=True,
    label=labels,
    color=["#1f77b4", "#ff7f0e"],  # Custom color palette
)

# Add labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)
plt.legend()

# Adjust x-axis range to appropriately display the new data
plt.xlim(left=0, right=600)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("hist_38.pdf", bbox_inches="tight")
