
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
import numpy as np
np.random.seed(42)
satisfaction_levels = np.array([0.05, 0.1, 0.2, 0.35, 0.5, 0.65, 0.75, 0.82, 0.95])
purchase_likelihood = np.array([0.08, 0.12, 0.25, 0.32, 0.48, 0.55, 0.65, 0.78, 0.9])
calibration_error = 0.18
text = f"Calibration Error:\n{calibration_error}"

# Axes Limits and Labels
xlabel_value = "Customer Satisfaction"
ylabel_value = "Purchase Likelihood"
title = "Customer Satisfaction vs Purchase Likelihood"
xlim_values = [0, 1]
ylim_values = [0, 1]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size to match the original image's dimensions
plt.figure(figsize=(8, 8))

# Colors
hist_color = "skyblue"
line_color = "darkred"
text_color = "blue"
edge_color = "black"

# Plot histogram using plt.hist and specify bins
plt.hist(satisfaction_levels, bins=9, weights=purchase_likelihood, color=hist_color, edgecolor=edge_color)

# Add diagonal dashed line
plt.plot([0, 1], [0, 1], linestyle="--", linewidth=1, color=line_color)

# Add text for calibration error
plt.text(0.08, 0.85, text, color=text_color, fontsize=18)

# Set labels and title
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)
plt.title(title)

# Adjust x and y axis limits to match the reference picture
plt.xlim(xlim_values)
plt.ylim(ylim_values)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("hist_40.pdf", bbox_inches="tight")
