

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
import numpy as np

np.random.seed(42)
# Generate new data for historical knowledge domain
confidence = np.array([0.1, 0.15, 0.25, 0.35, 0.45, 0.55, 0.65, 0.75, 0.85, 0.95])
accuracy = np.array([0.14, 0.20, 0.30, 0.37, 0.40, 0.50, 0.55, 0.60, 0.70, 0.75])
calibration_error = 0.22
text = f"Calibration Error:\n{calibration_error}"

# Axes Limits and Labels
xlabel_value = "Confidence in Historical Knowledge"
ylabel_value = "Accuracy of Historical Knowledge"
title = "Confidence vs. Accuracy in Historical Knowledge"
xlim_values = [0, 1]
ylim_values = [0, 1]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size to match the original image's dimensions
plt.figure(figsize=(8, 8))

# Plot histogram using plt.hist and specify bins
plt.hist(confidence, bins=10, weights=accuracy, color="#6a5acd", edgecolor="#483d8b")

# Add diagonal dashed line
plt.plot([0, 1], [0, 1], linestyle="--", linewidth=1, color="#cd853f")

# Add text for calibration error
plt.text(0.08, 0.85, text, color="#6b8e23", fontsize=18)

# Set labels and title
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)
plt.title(title)

# Adjust x and y axis limits to match the reference picture
plt.xlim(xlim_values)
plt.ylim(ylim_values)

# Add grid for better readability
plt.grid(True, linestyle='--', linewidth=0.5)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("hist_41.pdf", bbox_inches="tight")
