
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# New sample data: Age groups and attendance overlap
age_group_overlap_religion = [0.05, 0.15, 0.25, 0.35, 0.45, 0.55, 0.65, 0.75, 0.85, 0.95]
attendance_counts = [150, 600, 1400, 2200, 3000, 3800, 3500, 2800, 2200, 1600]

# Axes Limits and Labels
xlabel_value = "Age Group Overlap (%)"
ylabel_value = "Attendance Counts"
title_value = "Religious Services Attendance Across Age Groups"
xlim_values = [0, 1.0]
ylim_values = [0, 4000]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a histogram
plt.figure(figsize=(8, 6))  # Adjusted for better readability
plt.hist(age_group_overlap_religion, bins=10, weights=attendance_counts, color="#4c9b82", alpha=0.8)

# Set the labels and title
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)
plt.title(title_value)

# Remove ticks on both axes
plt.tick_params(axis="both", which="both", length=0)

# Set the range for the axes
plt.xlim(xlim_values)
plt.ylim(ylim_values)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and display the plot
plt.tight_layout()
plt.savefig("hist_43.pdf", bbox_inches="tight")
