
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Simulated viewership hours data (hours)
viewership_platform_a = np.random.normal(120, 15, 1000)
viewership_platform_b = np.random.normal(180, 30, 1000)

# Labels
xlabel = "Viewership Hours"
ylabel = "Frequency"
binslist = [30, 30]
labels = ["Platform A", "Platform B"]
title = "Viewership Distribution"
supertitle = "Comparison of Viewership Hours across Platforms"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(10, 3))

# Left subplot
ax_left = plt.subplot(1, 2, 1)
plt.hist(
    viewership_platform_a,
    bins=binslist[0],
    alpha=0.7,
    label=labels[0],
    color="#ff9999",
    edgecolor='black',
    zorder=2,
)
plt.hist(
    viewership_platform_b,
    bins=binslist[1],
    alpha=0.7,
    label=labels[1],
    color="#99ff99",
    edgecolor='black',
    zorder=3,
)
leg = plt.legend(frameon=False, fontsize=9)
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title("Group Comparison", fontsize=12)
plt.tick_params(axis="both", which="both", length=0)
plt.gca().set_facecolor("#f0f0f0")
plt.grid(True, color="white", zorder=0)
for spine in plt.gca().spines.values():
    spine.set_visible(False)

# Right subplot
ax_right = plt.subplot(1, 2, 2)
plt.hist(
    viewership_platform_a,
    bins=binslist[0],
    alpha=0.7,
    label=labels[0],
    color="#ff9999",
    edgecolor='black',
    zorder=2,
)
plt.hist(
    viewership_platform_b,
    bins=binslist[1],
    alpha=0.7,
    label=labels[1],
    color="#99ff99",
    edgecolor='black',
    zorder=3,
)
leg = plt.legend(frameon=False, fontsize=9)
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title("Group Comparison", fontsize=12)
plt.tick_params(axis="both", which="both", length=0)
plt.gca().set_facecolor("#f0f0f0")
plt.grid(True, color="white", zorder=0)
for spine in plt.gca().spines.values():
    spine.set_visible(False)

# Set axis spine colors to black
for ax in [ax_left, ax_right]:
    for spine in ax.spines.values():
        spine.set_edgecolor("black")

# ===================
# Part 4: Saving Output
# ===================
plt.suptitle(supertitle, fontsize=14)
plt.tight_layout(rect=[0, 0, 1, 0.95])
plt.savefig("hist_49.pdf", bbox_inches="tight")
