

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Generate new data for the health domain
# Simulate Blood Pressure (BP) and Cholesterol levels
data1 = np.random.normal(120, 15, 500)  # Blood Pressure
data2 = np.random.normal(200, 30, 500)  # Cholesterol Levels

# Text labels and parameters
labels = ["Blood Pressure (BP)", "Cholesterol Levels"]
xlabel = "Measurement"
ylabel = "Frequency"
titlelist = [
    "(a) Age Group 20-30",
    "(b) Age Group 31-40",
    "(c) Age Group 41-50",
    "(d) Age Group 51-60",
]
suptitle = "Distribution of Blood Pressure and Cholesterol Levels Across Different Age Groups"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, axs = plt.subplots(2, 2, figsize=(12, 10))
colors = ["#ff7f0e", "#1f77b4"]  # Vibrant color scheme

# Plot histograms for each subplot
for i, (ax, title) in enumerate(zip(axs.flatten(), titlelist)):
    ax.hist(
        data1,
        bins=30,
        density=True,
        alpha=0.7,
        color=colors[0],
        edgecolor="black",
        linewidth=0.5,
        label=labels[0]
    )
    ax.hist(
        data2,
        bins=30,
        density=True,
        alpha=0.7,
        color=colors[1],
        edgecolor="black",
        linewidth=0.5,
        label=labels[1]
    )
    ax.set_xlabel(xlabel)
    ax.set_ylabel(ylabel)
    ax.set_title(title, fontsize=12)
    if i == 0:  # Place legend on the first subplot
        ax.legend()

# Set a super title for the entire figure
plt.suptitle(suptitle, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout(rect=[0, 0, 1, 0.95])
plt.savefig("hist_51.pdf", bbox_inches="tight")

