
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(54)

# Generate random data for illustration purposes (representing stock prices)
companies_data = {
    "Company A": np.random.lognormal(mean=3, sigma=0.5, size=1000),
    "Company B": np.random.lognormal(mean=3.2, sigma=0.6, size=1000),
    "Company C": np.random.lognormal(mean=2.8, sigma=0.7, size=1000),
    "Company D": np.random.lognormal(mean=3.5, sigma=0.5, size=1000),
    "Company E": np.random.lognormal(mean=3.7, sigma=0.8, size=1000),
    "Company F": np.random.lognormal(mean=3.6, sigma=0.6, size=1000),
    "Company G": np.random.lognormal(mean=3.4, sigma=0.7, size=1000),
    "Company H": np.random.lognormal(mean=3.3, sigma=0.5, size=1000),
}

# Define the titles for each subplot
titles = [
    "Company A Stock Prices",
    "Company B Stock Prices",
    "Company C Stock Prices",
    "Company D Stock Prices",
    "Company E Stock Prices",
    "Company F Stock Prices",
    "Company G Stock Prices",
    "Company H Stock Prices",
]

# Define labels
xlabel = "Stock Price (USD)"
ylabel = "Density"
bins = 25
xvline = 100  # Hypothetical threshold for high stock price

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Define the colors for each subplot
colors = ["forestgreen", "darkgreen", "mediumblue", "darkblue", "seagreen", "teal", "dodgerblue", "navy"]
  
# Set the figure size to match the original image's dimensions
plt.figure(figsize=(7, 8))  # Adjusted to match 720x864 dimensions

# Create subplots
for i, (company, data) in enumerate(companies_data.items()):
    plt.subplot(4, 2, i + 1)
    plt.hist(data, bins=bins, density=True, alpha=0.6, color=colors[i], range=(0, 300))
    plt.title(titles[i])
    plt.xlabel(xlabel)
    plt.ylabel(ylabel)
    plt.axvline(
        x=xvline, color="k", linestyle="--", linewidth=1
    )  # Typical high stock price threshold
    plt.grid(True, linestyle='--', alpha=0.5)  # Adding grid for readability

# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout and show the plot
plt.tight_layout(pad=0.4, w_pad=0.5, h_pad=1.0)  # Adjusted padding for tighter layout
plt.savefig("hist_54.pdf", bbox_inches="tight")
